/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

   Filename:
    $Workfile: $
   Last Modification:
    $Author: Robert $
    $Modtime: $
    $Revision: 6464 $

   Targets:
     MQX   : yes

   Description:
   cifX parallel DPM Interface

   Changes:

     Version   Date        Author   Description
      ----------------------------------------------------------------------------------
      2        23.07.2014  RM       changed function parameters of MQX_ParDPM_Read
                                    and MQX_ParDPM_Write according to new toolkit types
      1        01.03.2011  SS       initial version

**************************************************************************************/

/*****************************************************************************/
/*! \file MQXParDPMInterface.h
*   cifX parallel DPM interface function definition                          */
/*****************************************************************************/

#ifndef MQX_PARDPMINTERFACE__H
#define MQX_PARDPMINTERFACE__H

#ifdef __cplusplus
extern "C"
{
#endif

#include "OS_Dependent.h"

int32_t MQX_ParDPM_Init( void);
void*   MQX_ParDPM_Read( void* pvDevInstance, void* pvAddr, void* pvData, uint32_t ulLen);
void*   MQX_ParDPM_Write( void* pvDevInstance, void* pvAddr, void* pvData, uint32_t ulLen);

#ifdef __cplusplus
}
#endif

#endif /* MQX_PARDPMINTERFACE__H */
